---
title: WAF phases · Cloudflare Web Application Firewall (WAF) docs
description: "The Web Application Firewall provides the following phases where
  you can create rulesets and rules:"
lastUpdated: 2025-10-17T11:29:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/reference/phases/
  md: https://developers.cloudflare.com/waf/reference/phases/index.md
---

The Web Application Firewall provides the following [phases](https://developers.cloudflare.com/ruleset-engine/about/phases/) where you can create rulesets and rules:

* `http_request_firewall_custom`
* `http_ratelimit`
* `http_request_firewall_managed`

These phases exist both at the account level and at the zone level. Considering the available phases and the two different levels, rules will be evaluated in the following order:

* Old dashboard

  | Security feature | Scope | Phase | Ruleset kind | Location in the dashboard |
  | - | - | - | - | - |
  | [Custom rulesets](https://developers.cloudflare.com/waf/account/custom-rulesets/)  | Account | `http_request_firewall_custom` | `custom` (create) `root` (deploy) | [Go to **WAF** ](https://dash.cloudflare.com/?to=/:account/application-security/waf)> **Custom rulesets** tab |
  | [Custom rules](https://developers.cloudflare.com/waf/custom-rules/) | Zone | `http_request_firewall_custom` | `zone` | Your zone > **Security** > **WAF** > **Custom rules** tab |
  | [Rate limiting rulesets](https://developers.cloudflare.com/waf/account/rate-limiting-rulesets/) | Account | `http_ratelimit` | `root` | [Go to **WAF** ](https://dash.cloudflare.com/?to=/:account/application-security/waf)> **Rate limiting rulesets** tab |
  | [Rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/) | Zone | `http_ratelimit` | `zone` | Your zone > **Security** > **WAF** > **Rate limiting rules** tab |
  | [Managed rulesets](https://developers.cloudflare.com/waf/account/managed-rulesets/) | Account | `http_request_firewall_managed` | `root` | [Go to **WAF** ](https://dash.cloudflare.com/?to=/:account/application-security/waf)> **Managed rulesets** tab |
  | [Managed rules](https://developers.cloudflare.com/waf/managed-rules/) | Zone | `http_request_firewall_managed` | `zone` | Your zone > **Security** > **WAF** > **Managed rules** tab |

* New dashboard

  | Security feature | Scope | Phase | Ruleset kind | Location in the dashboard |
  | - | - | - | - | - |
  | [Custom rulesets](https://developers.cloudflare.com/waf/account/custom-rulesets/)  | Account | `http_request_firewall_custom` | `custom` (create) `root` (deploy) | [Go to **WAF** ](https://dash.cloudflare.com/?to=/:account/application-security/waf)> **Custom rulesets** tab |
  | [Custom rules](https://developers.cloudflare.com/waf/custom-rules/) | Zone | `http_request_firewall_custom` | `zone` | [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules) |
  | [Rate limiting rulesets](https://developers.cloudflare.com/waf/account/rate-limiting-rulesets/) | Account | `http_ratelimit` | `root` | [Go to **WAF** ](https://dash.cloudflare.com/?to=/:account/application-security/waf)> **Rate limiting rulesets** tab |
  | [Rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/) | Zone | `http_ratelimit` | `zone` | [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules) |
  | [Managed rulesets](https://developers.cloudflare.com/waf/account/managed-rulesets/) | Account | `http_request_firewall_managed` | `root` | [Go to **WAF** ](https://dash.cloudflare.com/?to=/:account/application-security/waf)> **Managed rulesets** tab |
  | [Managed rules](https://developers.cloudflare.com/waf/managed-rules/) | Zone | `http_request_firewall_managed` | `zone` | [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules) |

To learn more about phases, refer to [Phases](https://developers.cloudflare.com/ruleset-engine/about/phases/) in the Ruleset Engine documentation.
