---
title: Error 1015 · Cloudflare Support docs
description: This error indicates that you are being rate limited by the website.
lastUpdated: 2025-07-03T20:28:17.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1015/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1015/index.md
---

## Error 1015: You are being rate limited

This error indicates that you are being rate limited by the website.

### Common cause

The site owner implemented [Rate Limiting](https://developers.cloudflare.com/waf/reference/legacy/old-rate-limiting/) that affects your visitor traffic.

Note

*Unable to purge* is another `1015` error code relating to [Cloudflare cache purge](https://developers.cloudflare.com/cache/how-to/purge-cache). Retry the cache purge and contact [Cloudflare support](https://developers.cloudflare.com/support/contacting-cloudflare-support/) if errors persist.

### Resolution

* If you are a site visitor, contact the site owner to request exclusion of your IP from rate limiting.
* If you are the site owner, review [Cloudflare Rate Limiting thresholds](https://developers.cloudflare.com/waf/reference/legacy/old-rate-limiting/) and adjust your Rate Limiting configuration.
* If your Rate Limiting blocks requests in a short time period (for example, one second) try increasing the time period to 10 seconds.

Note

If you expect a new Cloudflare Worker to exceed rate limits, refer to the [Workers documentation](https://developers.cloudflare.com/workers/platform/limits/) for guidance.
