---
title: Asides · Cloudflare Style Guide
description: Asides are a built-in component provided by Starlight. Although
  there are more options, use only the ones below.
lastUpdated: 2025-10-03T21:32:22.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/asides/
  md: https://developers.cloudflare.com/style-guide/components/asides/index.md
---

Asides are a built-in component provided by [Starlight](https://starlight.astro.build/components/asides/). Although there are more options, use only the ones below.

## Note

Use Note for small additions or when you need to provide extra context that is not essential to the main content.

If you do not provide a header, this aside will default to `Note`.

```mdx
:::note[Header]
Hello, world!
:::
```

Header

Hello, world!

## Caution

Use Caution to highlight actions that could cause issues for a user.

If you do not provide a header, this aside will default to `Warning`.

```mdx
:::caution[Feature conflict]
If you use feature A and feature B together, your configuration will not work.
:::
```

Feature conflict

If you use feature A and feature B together, your configuration will not work.

## Tip

Use Tip to share best practices or opinionated use cases that do not fit into the main documentation.

If you do not provide a header, this aside will default to `Tip`.

```mdx
:::tip[Best practice]
Cloudflare recommends you use [1.1.1.1](/1.1.1.1/) as your DNS resolver.
:::
```

Best practice

Cloudflare recommends you use [1.1.1.1](https://developers.cloudflare.com/1.1.1.1/) as your DNS resolver.
