---
title: Connection reuse · Cloudflare Smart Shield docs
description: Smart Shield leverages Cloudflare's optimized infrastructure to
  package multiple requests from an upper-tier into a single connection to your
  origin. This means overall connections to your origin are lowered by 30% on
  average. Refer to the blog post for details.
lastUpdated: 2025-10-02T15:01:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/smart-shield/concepts/connection-reuse/
  md: https://developers.cloudflare.com/smart-shield/concepts/connection-reuse/index.md
---

Smart Shield leverages Cloudflare's optimized infrastructure to package multiple requests from an [upper-tier](https://developers.cloudflare.com/smart-shield/configuration/smart-tiered-cache/) into a single connection to your origin. This means overall connections to your origin are lowered by 30% on average. Refer to the [blog post](https://blog.cloudflare.com/introducing-observatory-and-smart-shield/#protecting-and-accelerating-origins-with-smart-connection-reuse) for details.

## About connection reuse

Implemented by HTTP/1.1, connection reuse describes multiple requests passing through one same connection (between one source IP:port and one destination IP:port). It is commonly the case even for simple websites nowadays.

For example, when a connection is initiated for `shop.example.com`, several embedded subresources may be requested - CSS, image files, advertisement, etc. This can mean hundreds of requests just for the website to load. Instead of having a one to one ratio of request per connection, a single connection is used for multiple requests.

With HTTP/2, requests can use the same connection even if they are for different domains.

For example, a connection initiated for `shop.example.com` can be used for requests for `blog.example.com` as well - as long as the requests have the same destination IP:port and the server TLS certificate is authoritative for both hostnames.
