---
title: http.request.body.multipart.content_types · Cloudflare Ruleset Engine docs
description: List of `Content-Type` headers for each part in the multipart body.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.multipart.content_types/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.multipart.content_types/index.md
---

# http.request.body.multipart.content\_types

`http.request.body.multipart.content_types` Array\<Array\<String>>

List of `Content-Type` headers for each part in the multipart body.

Requires a Cloudflare Enterprise plan with a paid add-on.

Example value:

```txt
[["text/plain"], ["image/jpeg"]]
```

Example usage:

```txt
any(http.request.body.multipart.content_types[*][0] == "application/octet-stream")
```

Warning

All `http.request.body.*` fields (except [`http.request.body.size` ](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.size/)) handle a given maximum body size, which varies per plan. For Enterprise customers, the maximum body size analyzed by Cloudflare is 128 KB; for lower Cloudflare plans, the maximum size is lower. You cannot define expressions that rely on request body data beyond the maximum size set for your plan. If the request body is larger, the body fields will contain a truncated value and the [`http.request.body.truncated` ](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.truncated/)field will be set to `true`. The [`http.request.body.size` ](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.size/)field will contain the full size of the request without any truncation.

The maximum body size applies only to the values of HTTP body fields — the origin server will still receive the complete request body.

Categories:

* Request
* Body
