---
title: Adaptive routing · Cloudflare Load Balancing docs
description: Adaptive routing controls features that modify the routing of
  requests to pools and endpoints in response to dynamic conditions, such as
  during the interval between active health monitoring requests.
lastUpdated: 2025-09-03T10:05:39.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/understand-basics/adaptive-routing/
  md: https://developers.cloudflare.com/load-balancing/understand-basics/adaptive-routing/index.md
---

Adaptive routing controls features that modify the routing of requests to pools and endpoints in response to dynamic conditions, such as during the interval between active health monitoring requests.

Zero-downtime failover will trigger a single retry only if there is another healthy endpoint in the pool and a [521, 522, 523, 525 or 526 error code](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-521/) is occurring. No other error codes will trigger a zero-downtime failover operation.

## Failover across pools

When there are no healthy endpoints in the same pool, failover across pools extend the zero-downtime failover of requests to healthy endpoints in alternate pools according to the failover order defined by traffic and endpoint steering.

### Enable failover across pools

1. In the Cloudflare dashboard, go to the **Load Balancing** page.

   [Go to **Load balancing**](https://dash.cloudflare.com/?to=/:account/load-balancing)

2. Navigate to your Load Balancers and select **Edit**.

3. From **Adaptive Routing**, enable **Failover across pools**.
